package name.remal.gradle_plugins

import name.remal.gradle_plugins.RemalGradlePlugins.IdeaSettingsPluginDisabledID
import name.remal.gradle_plugins.utils.PluginIds.IDEA_PLUGIN_ID
import name.remal.gradle_plugins.utils.ProjectPlugin
import name.remal.gradle_plugins.utils.get
import name.remal.gradle_plugins.utils.isDisabledBy
import name.remal.gradle_plugins.utils.withPlugin
import org.gradle.api.Project
import org.gradle.plugins.ide.idea.model.IdeaModel

@API
class IdeaSettingsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        if (project.isDisabledBy(IdeaSettingsPluginDisabledID)) return

        project.withPlugin(IDEA_PLUGIN_ID) {
            setupDependenciesResolution(project)
        }
    }

    private fun setupDependenciesResolution(project: Project) {
        project[IdeaModel::class.java].module?.apply {
            isDownloadJavadoc = true
            isDownloadSources = true
        }
    }

}
