package name.remal.gradle_plugins

import name.remal.gradle_plugins.RemalGradlePlugins.KotlinSettingsPluginDisabledID
import name.remal.gradle_plugins.dsl.java
import name.remal.gradle_plugins.dsl.kotlin
import name.remal.gradle_plugins.dsl.makeSrcDirsUnique
import name.remal.gradle_plugins.utils.*
import name.remal.gradle_plugins.utils.PluginIds.*
import org.gradle.api.Project
import org.jetbrains.kotlin.gradle.plugin.KaptExtension
import org.jetbrains.kotlin.gradle.tasks.Kotlin2JsCompile
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile

@API
class KotlinSettingsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        if (project.isDisabledBy(KotlinSettingsPluginDisabledID)) return

        project.withOneOfPlugin(KOTLIN_PLUGIN_IDS, KOTLIN2JS_PLUGIN_IDS) { setupKotlinCommon(project) }
        project.withPlugin(KOTLIN_PLUGIN_IDS) { setupKotlinJvm(project) }
        project.withPlugin(KOTLIN2JS_PLUGIN_IDS) { setupKotlinJs(project) }

        project.withPlugin(KOTLIN_KAPT_PLUGIN_IDS) { setupKapt(project) }
    }

    private fun setupKotlinCommon(project: Project) {
        project.applyPlugin(JAVA_PLUGIN_ID)
        project.applyPlugin(JavaSettingsPlugin::class.java)

        project.afterEvaluateOrdered(Int.MAX_VALUE) {
            project.java.sourceSets.configure {
                it.resources.makeSrcDirsUnique()
                it.java.makeSrcDirsUnique()
                it.allJava.makeSrcDirsUnique()
                it.allSource.makeSrcDirsUnique()
                it.kotlin.kotlin.makeSrcDirsUnique()
            }
        }
    }

    private fun setupKotlinJvm(project: Project) {
        project.applyPluginIfExists(KOTLIN_ALL_OPEN_PLUGIN_IDS)
        project.applyPluginIfExists(KOTLIN_NOARG_PLUGIN_IDS)
        project.applyPluginIfExists(KOTLIN_SPRING_PLUGIN_IDS)
        project.applyPluginIfExists(KOTLIN_JPA_PLUGIN_IDS)

        project.tasks.configure(KotlinCompile::class.java) {
            val options = it.kotlinOptions
            options.jvmTarget = "1.8"
            options.javaParameters = true
        }
    }

    private fun setupKotlinJs(project: Project) {
        project.tasks.configure(Kotlin2JsCompile::class.java) {
            val options = it.kotlinOptions
            options.metaInfo = true
            options.sourceMap = true
            options.moduleKind = "umd"
            options.noStdlib = false
        }
    }

    private fun setupKapt(project: Project) {
        project[KaptExtension::class.java].let { kapt ->
            kapt.correctErrorTypes = true
        }
    }

}
