package name.remal.gradle_plugins

import name.remal.gradle_plugins.RemalGradlePlugins.OSDetectorPluginDisabledID
import name.remal.gradle_plugins.utils.ProjectPlugin
import name.remal.gradle_plugins.utils.isDisabledBy
import org.gradle.api.Project
import org.slf4j.LoggerFactory
import java.util.*
import kr.motd.maven.os.Detector as DetectorImpl

@API
class OSDetectorPlugin : ProjectPlugin() {

    companion object {
        const val OS_DETECTOR_EXTENSION_NAME = "osdetector"
    }

    override fun apply(project: Project) {
        if (project.isDisabledBy(OSDetectorPluginDisabledID)) return

        project.extensions.create(OS_DETECTOR_EXTENSION_NAME, OSDetectorExtension::class.java)
    }

}


@API
class OSDetectorExtension : Detector by DetectorObject


private interface Detector {
    val name: String?
    val arch: String?
    val classifier: String?
    val version: String?
}

private object DetectorObject : DetectorImpl(), Detector {

    private val properties: Properties by lazy {
        Properties().apply {
            detect(this, null)
        }
    }

    override val name: String? get() = properties[DETECTED_NAME]?.toString()
    override val arch: String? get() = properties[DETECTED_ARCH]?.toString()
    override val classifier: String? get() = properties[DETECTED_CLASSIFIER]?.toString()
    override val version: String? get() = properties[DETECTED_VERSION]?.toString()

    override fun logProperty(name: String?, value: String?) {
        LoggerFactory.getLogger(DetectorImpl::class.java).info("{}={}", name, value)
    }

    override fun log(message: String?) {
        LoggerFactory.getLogger(DetectorImpl::class.java).info(message)
    }

}
