package name.remal.gradle_plugins

import name.remal.gradle_plugins.RemalGradlePlugins.QualitySettingsPluginDisabledID
import name.remal.gradle_plugins.dsl.java
import name.remal.gradle_plugins.utils.*
import name.remal.gradle_plugins.utils.PluginIds.JAVA_PLUGIN_ID
import name.remal.gradle_plugins.utils.PluginIds.QUALITY_PLUGIN_ID
import org.gradle.api.Project
import ru.vyarus.gradle.plugin.quality.QualityExtension

@API
class QualitySettingsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        if (project.isDisabledBy(QualitySettingsPluginDisabledID)) return

        project.withPlugins(JAVA_PLUGIN_ID, QUALITY_PLUGIN_ID) {
            project.applyPlugin(FindbugsSettingsPlugin::class.java)

            project[QualityExtension::class.java].apply {
                isAutoRegistration = false
                configDir = project.rootDir.resolve("/gradle/config/").absolutePath
                excludeSources = project.fileTree(project.buildDir)
                sourceSets = project.java.sourceSets

                isStrict = false
            }
        }
    }

}
