package name.remal.gradle_plugins;
import javax.annotation.Nonnull;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import java.util.*;
import com.google.common.collect.*;
import static java.util.Arrays.*;
import static java.util.Collections.*;
@SuppressWarnings("ALL")
public interface RemalGradlePlugins {
    @Nonnull String ClassesRelocationPluginID = new String("name.remal.classes-relocation");
    @Nonnull String ClassesRelocationPluginDisabledID = new String("name.remal.classes-relocation.disabled");
    @Nonnull String VCSInfoPluginID = new String("name.remal.vcs-info");
    @Nonnull String VCSInfoPluginDisabledID = new String("name.remal.vcs-info.disabled");
    @Nonnull String MergedCoverageMetricsPluginID = new String("name.remal.merged-coverage-metrics");
    @Nonnull String MergedCoverageMetricsPluginDisabledID = new String("name.remal.merged-coverage-metrics.disabled");
    @Nonnull String GroovySettingsPluginID = new String("name.remal.groovy-settings");
    @Nonnull String GroovySettingsPluginDisabledID = new String("name.remal.groovy-settings.disabled");
    @Nonnull String SigningSettingsPluginID = new String("name.remal.signing-settings");
    @Nonnull String SigningSettingsPluginDisabledID = new String("name.remal.signing-settings.disabled");
    @Nonnull String DownloadTaskSettingPluginID = new String("name.remal.download-task-settings");
    @Nonnull String DownloadTaskSettingPluginDisabledID = new String("name.remal.download-task-settings.disabled");
    @Nonnull String CheckGradleUpdatesPluginID = new String("name.remal.check-gradle-updates");
    @Nonnull String CheckGradleUpdatesPluginDisabledID = new String("name.remal.check-gradle-updates.disabled");
    @Nonnull String CheckUpdatesPluginID = new String("name.remal.check-updates");
    @Nonnull String CheckUpdatesPluginDisabledID = new String("name.remal.check-updates.disabled");
    @Nonnull String FindbugsSettingsPluginID = new String("name.remal.findbugs-settings");
    @Nonnull String FindbugsSettingsPluginDisabledID = new String("name.remal.findbugs-settings.disabled");
    @Nonnull String EclipseSettingsPluginID = new String("name.remal.eclipse-settings");
    @Nonnull String EclipseSettingsPluginDisabledID = new String("name.remal.eclipse-settings.disabled");
    @Nonnull String GenerateSourcesPluginID = new String("name.remal.generate-sources");
    @Nonnull String GenerateSourcesPluginDisabledID = new String("name.remal.generate-sources.disabled");
    @Nonnull String GitlabToolsPluginID = new String("name.remal.gitlab-tools");
    @Nonnull String GitlabToolsPluginDisabledID = new String("name.remal.gitlab-tools.disabled");
    @Nonnull String MergeJavaResourcesPluginID = new String("name.remal.merge-java-resources");
    @Nonnull String MergeJavaResourcesPluginDisabledID = new String("name.remal.merge-java-resources.disabled");
    @Nonnull String CheckDependencyUpdatesPluginID = new String("name.remal.check-dependency-updates");
    @Nonnull String CheckDependencyUpdatesPluginDisabledID = new String("name.remal.check-dependency-updates.disabled");
    @Nonnull String AptPluginID = new String("name.remal.apt");
    @Nonnull String AptPluginDisabledID = new String("name.remal.apt.disabled");
    @Nonnull String BintraySettingsPluginID = new String("name.remal.bintray-settings");
    @Nonnull String BintraySettingsPluginDisabledID = new String("name.remal.bintray-settings.disabled");
    @Nonnull String JavaSettingsPluginID = new String("name.remal.java-settings");
    @Nonnull String JavaSettingsPluginDisabledID = new String("name.remal.java-settings.disabled");
    @Nonnull String OSDetectorPluginID = new String("name.remal.osdetector");
    @Nonnull String OSDetectorPluginDisabledID = new String("name.remal.osdetector.disabled");
    @Nonnull String IdeaExternalAnnotationsPluginID = new String("name.remal.idea-external-annotations");
    @Nonnull String IdeaExternalAnnotationsPluginDisabledID = new String("name.remal.idea-external-annotations.disabled");
    @Nonnull String PackedDependenciesPluginID = new String("name.remal.packed-dependencies");
    @Nonnull String PackedDependenciesPluginDisabledID = new String("name.remal.packed-dependencies.disabled");
    @Nonnull String DefaultPluginsPluginID = new String("name.remal.default-plugins");
    @Nonnull String DefaultPluginsPluginDisabledID = new String("name.remal.default-plugins.disabled");
    @Nonnull String VCSAutoVersionPluginID = new String("name.remal.vcs-auto-version");
    @Nonnull String VCSAutoVersionPluginDisabledID = new String("name.remal.vcs-auto-version.disabled");
    @Nonnull String DynamicDependenciesPluginID = new String("name.remal.dynamic-dependencies");
    @Nonnull String DynamicDependenciesPluginDisabledID = new String("name.remal.dynamic-dependencies.disabled");
    @Nonnull String JUnitPlatformSettingsPluginID = new String("name.remal.junit-platform-settings");
    @Nonnull String JUnitPlatformSettingsPluginDisabledID = new String("name.remal.junit-platform-settings.disabled");
    @Nonnull String CoverageMetricsPluginID = new String("name.remal.coverage-metrics");
    @Nonnull String CoverageMetricsPluginDisabledID = new String("name.remal.coverage-metrics.disabled");
    @Nonnull String SimpleBuildCachePluginID = new String("name.remal.simple-build-cache");
    @Nonnull String SimpleBuildCachePluginDisabledID = new String("name.remal.simple-build-cache.disabled");
    @Nonnull String KotlinSettingsPluginID = new String("name.remal.kotlin-settings");
    @Nonnull String KotlinSettingsPluginDisabledID = new String("name.remal.kotlin-settings.disabled");
    @Nonnull String QualitySettingsPluginID = new String("name.remal.quality-settings");
    @Nonnull String QualitySettingsPluginDisabledID = new String("name.remal.quality-settings.disabled");
    @Nonnull String FlattenJavaProjectPluginID = new String("name.remal.flatten-java-project");
    @Nonnull String FlattenJavaProjectPluginDisabledID = new String("name.remal.flatten-java-project.disabled");
    @Nonnull String VersionSelectionsPluginID = new String("name.remal.version-selections");
    @Nonnull String VersionSelectionsPluginDisabledID = new String("name.remal.version-selections.disabled");
    @Nonnull String IdeaSettingsPluginID = new String("name.remal.idea-settings");
    @Nonnull String IdeaSettingsPluginDisabledID = new String("name.remal.idea-settings.disabled");
    @Nonnull String IdeaExtendedSettingsPluginID = new String("name.remal.idea-extended-settings");
    @Nonnull String IdeaExtendedSettingsPluginDisabledID = new String("name.remal.idea-extended-settings.disabled");
    @Nonnull String FastAnnotationProcessorsPluginID = new String("name.remal.fast-annotation-processors-in-kotlin");
    @Nonnull String FastAnnotationProcessorsPluginDisabledID = new String("name.remal.fast-annotation-processors-in-kotlin.disabled");
    @Nonnull String PublishSettingsPluginID = new String("name.remal.publish-settings");
    @Nonnull String PublishSettingsPluginDisabledID = new String("name.remal.publish-settings.disabled");
    @Nonnull String IntegrationTestingPluginID = new String("name.remal.integration-testing");
    @Nonnull String IntegrationTestingPluginDisabledID = new String("name.remal.integration-testing.disabled");
    @Nonnull String CommonSettingsPluginID = new String("name.remal.common-settings");
    @Nonnull String CommonSettingsPluginDisabledID = new String("name.remal.common-settings.disabled");
    @Nonnull String CopyDependenciesPluginID = new String("name.remal.copy-dependencies");
    @Nonnull String CopyDependenciesPluginDisabledID = new String("name.remal.copy-dependencies.disabled");
    @Nonnull String AgentPluginID = new String("name.remal.agent");
    @Nonnull String AgentPluginDisabledID = new String("name.remal.agent.disabled");

    @Nonnull BiMap<Class<? extends Plugin<Project>>, String> PLUGIN_CLASS_TO_ID = ImmutableBiMap.<Class<? extends Plugin<Project>>, String>builder()
        .put(name.remal.gradle_plugins.ClassesRelocationPlugin.class, "name.remal.classes-relocation")
        .put(name.remal.gradle_plugins.ClassesRelocationPluginDisabled.class, "name.remal.classes-relocation.disabled")
        .put(name.remal.gradle_plugins.VCSInfoPlugin.class, "name.remal.vcs-info")
        .put(name.remal.gradle_plugins.VCSInfoPluginDisabled.class, "name.remal.vcs-info.disabled")
        .put(name.remal.gradle_plugins.MergedCoverageMetricsPlugin.class, "name.remal.merged-coverage-metrics")
        .put(name.remal.gradle_plugins.MergedCoverageMetricsPluginDisabled.class, "name.remal.merged-coverage-metrics.disabled")
        .put(name.remal.gradle_plugins.GroovySettingsPlugin.class, "name.remal.groovy-settings")
        .put(name.remal.gradle_plugins.GroovySettingsPluginDisabled.class, "name.remal.groovy-settings.disabled")
        .put(name.remal.gradle_plugins.SigningSettingsPlugin.class, "name.remal.signing-settings")
        .put(name.remal.gradle_plugins.SigningSettingsPluginDisabled.class, "name.remal.signing-settings.disabled")
        .put(name.remal.gradle_plugins.DownloadTaskSettingPlugin.class, "name.remal.download-task-settings")
        .put(name.remal.gradle_plugins.DownloadTaskSettingPluginDisabled.class, "name.remal.download-task-settings.disabled")
        .put(name.remal.gradle_plugins.CheckGradleUpdatesPlugin.class, "name.remal.check-gradle-updates")
        .put(name.remal.gradle_plugins.CheckGradleUpdatesPluginDisabled.class, "name.remal.check-gradle-updates.disabled")
        .put(name.remal.gradle_plugins.CheckUpdatesPlugin.class, "name.remal.check-updates")
        .put(name.remal.gradle_plugins.CheckUpdatesPluginDisabled.class, "name.remal.check-updates.disabled")
        .put(name.remal.gradle_plugins.FindbugsSettingsPlugin.class, "name.remal.findbugs-settings")
        .put(name.remal.gradle_plugins.FindbugsSettingsPluginDisabled.class, "name.remal.findbugs-settings.disabled")
        .put(name.remal.gradle_plugins.EclipseSettingsPlugin.class, "name.remal.eclipse-settings")
        .put(name.remal.gradle_plugins.EclipseSettingsPluginDisabled.class, "name.remal.eclipse-settings.disabled")
        .put(name.remal.gradle_plugins.GenerateSourcesPlugin.class, "name.remal.generate-sources")
        .put(name.remal.gradle_plugins.GenerateSourcesPluginDisabled.class, "name.remal.generate-sources.disabled")
        .put(name.remal.gradle_plugins.GitlabToolsPlugin.class, "name.remal.gitlab-tools")
        .put(name.remal.gradle_plugins.GitlabToolsPluginDisabled.class, "name.remal.gitlab-tools.disabled")
        .put(name.remal.gradle_plugins.MergeJavaResourcesPlugin.class, "name.remal.merge-java-resources")
        .put(name.remal.gradle_plugins.MergeJavaResourcesPluginDisabled.class, "name.remal.merge-java-resources.disabled")
        .put(name.remal.gradle_plugins.CheckDependencyUpdatesPlugin.class, "name.remal.check-dependency-updates")
        .put(name.remal.gradle_plugins.CheckDependencyUpdatesPluginDisabled.class, "name.remal.check-dependency-updates.disabled")
        .put(name.remal.gradle_plugins.AptPlugin.class, "name.remal.apt")
        .put(name.remal.gradle_plugins.AptPluginDisabled.class, "name.remal.apt.disabled")
        .put(name.remal.gradle_plugins.BintraySettingsPlugin.class, "name.remal.bintray-settings")
        .put(name.remal.gradle_plugins.BintraySettingsPluginDisabled.class, "name.remal.bintray-settings.disabled")
        .put(name.remal.gradle_plugins.JavaSettingsPlugin.class, "name.remal.java-settings")
        .put(name.remal.gradle_plugins.JavaSettingsPluginDisabled.class, "name.remal.java-settings.disabled")
        .put(name.remal.gradle_plugins.OSDetectorPlugin.class, "name.remal.osdetector")
        .put(name.remal.gradle_plugins.OSDetectorPluginDisabled.class, "name.remal.osdetector.disabled")
        .put(name.remal.gradle_plugins.IdeaExternalAnnotationsPlugin.class, "name.remal.idea-external-annotations")
        .put(name.remal.gradle_plugins.IdeaExternalAnnotationsPluginDisabled.class, "name.remal.idea-external-annotations.disabled")
        .put(name.remal.gradle_plugins.PackedDependenciesPlugin.class, "name.remal.packed-dependencies")
        .put(name.remal.gradle_plugins.PackedDependenciesPluginDisabled.class, "name.remal.packed-dependencies.disabled")
        .put(name.remal.gradle_plugins.DefaultPluginsPlugin.class, "name.remal.default-plugins")
        .put(name.remal.gradle_plugins.DefaultPluginsPluginDisabled.class, "name.remal.default-plugins.disabled")
        .put(name.remal.gradle_plugins.VCSAutoVersionPlugin.class, "name.remal.vcs-auto-version")
        .put(name.remal.gradle_plugins.VCSAutoVersionPluginDisabled.class, "name.remal.vcs-auto-version.disabled")
        .put(name.remal.gradle_plugins.DynamicDependenciesPlugin.class, "name.remal.dynamic-dependencies")
        .put(name.remal.gradle_plugins.DynamicDependenciesPluginDisabled.class, "name.remal.dynamic-dependencies.disabled")
        .put(name.remal.gradle_plugins.JUnitPlatformSettingsPlugin.class, "name.remal.junit-platform-settings")
        .put(name.remal.gradle_plugins.JUnitPlatformSettingsPluginDisabled.class, "name.remal.junit-platform-settings.disabled")
        .put(name.remal.gradle_plugins.CoverageMetricsPlugin.class, "name.remal.coverage-metrics")
        .put(name.remal.gradle_plugins.CoverageMetricsPluginDisabled.class, "name.remal.coverage-metrics.disabled")
        .put(name.remal.gradle_plugins.SimpleBuildCachePlugin.class, "name.remal.simple-build-cache")
        .put(name.remal.gradle_plugins.SimpleBuildCachePluginDisabled.class, "name.remal.simple-build-cache.disabled")
        .put(name.remal.gradle_plugins.KotlinSettingsPlugin.class, "name.remal.kotlin-settings")
        .put(name.remal.gradle_plugins.KotlinSettingsPluginDisabled.class, "name.remal.kotlin-settings.disabled")
        .put(name.remal.gradle_plugins.QualitySettingsPlugin.class, "name.remal.quality-settings")
        .put(name.remal.gradle_plugins.QualitySettingsPluginDisabled.class, "name.remal.quality-settings.disabled")
        .put(name.remal.gradle_plugins.FlattenJavaProjectPlugin.class, "name.remal.flatten-java-project")
        .put(name.remal.gradle_plugins.FlattenJavaProjectPluginDisabled.class, "name.remal.flatten-java-project.disabled")
        .put(name.remal.gradle_plugins.VersionSelectionsPlugin.class, "name.remal.version-selections")
        .put(name.remal.gradle_plugins.VersionSelectionsPluginDisabled.class, "name.remal.version-selections.disabled")
        .put(name.remal.gradle_plugins.IdeaSettingsPlugin.class, "name.remal.idea-settings")
        .put(name.remal.gradle_plugins.IdeaSettingsPluginDisabled.class, "name.remal.idea-settings.disabled")
        .put(name.remal.gradle_plugins.IdeaExtendedSettingsPlugin.class, "name.remal.idea-extended-settings")
        .put(name.remal.gradle_plugins.IdeaExtendedSettingsPluginDisabled.class, "name.remal.idea-extended-settings.disabled")
        .put(name.remal.gradle_plugins.FastAnnotationProcessorsPlugin.class, "name.remal.fast-annotation-processors-in-kotlin")
        .put(name.remal.gradle_plugins.FastAnnotationProcessorsPluginDisabled.class, "name.remal.fast-annotation-processors-in-kotlin.disabled")
        .put(name.remal.gradle_plugins.PublishSettingsPlugin.class, "name.remal.publish-settings")
        .put(name.remal.gradle_plugins.PublishSettingsPluginDisabled.class, "name.remal.publish-settings.disabled")
        .put(name.remal.gradle_plugins.IntegrationTestingPlugin.class, "name.remal.integration-testing")
        .put(name.remal.gradle_plugins.IntegrationTestingPluginDisabled.class, "name.remal.integration-testing.disabled")
        .put(name.remal.gradle_plugins.CommonSettingsPlugin.class, "name.remal.common-settings")
        .put(name.remal.gradle_plugins.CommonSettingsPluginDisabled.class, "name.remal.common-settings.disabled")
        .put(name.remal.gradle_plugins.CopyDependenciesPlugin.class, "name.remal.copy-dependencies")
        .put(name.remal.gradle_plugins.CopyDependenciesPluginDisabled.class, "name.remal.copy-dependencies.disabled")
        .put(name.remal.gradle_plugins.AgentPlugin.class, "name.remal.agent")
        .put(name.remal.gradle_plugins.AgentPluginDisabled.class, "name.remal.agent.disabled")
        .build();

    @Nonnull BiMap<String, Class<? extends Plugin<Project>>> PLUGIN_ID_TO_CLASS = PLUGIN_CLASS_TO_ID.inverse();
}