package name.remal.gradle_plugins

import name.remal.gradle_plugins.RemalGradlePlugins.SimpleBuildCachePluginDisabledID
import name.remal.gradle_plugins.dsl.createDirectories
import name.remal.gradle_plugins.dsl.encodeURIComponent
import name.remal.gradle_plugins.utils.ProjectPlugin
import name.remal.gradle_plugins.utils.isDisabledBy
import org.gradle.api.Project
import java.io.File

@API
class SimpleBuildCachePlugin : ProjectPlugin() {

    companion object {
        const val SIMPLE_BUILD_CACHE_EXTENSION_NAME = "simpleBuildCache"
    }

    override fun apply(project: Project) {
        if (project.isDisabledBy(SimpleBuildCachePluginDisabledID)) return

        val simpleBuildCache = project.extensions.create(SIMPLE_BUILD_CACHE_EXTENSION_NAME, SimpleBuildCacheExtension::class.java, project)

        project.afterEvaluate {
            val version = simpleBuildCache.version.toString()
            simpleBuildCache.dir
                .createDirectories()
                .parentFile.listFiles()
                ?.forEach { file ->
                    if (version != file.name) {
                        file.deleteRecursively()
                    }
                }
        }
    }

}

@API
class SimpleBuildCacheExtension(project: Project) {

    private companion object {
        private val DEFAULT_VERSION = "1"
    }

    var baseDir: File = project.projectDir.resolve("build-cache")
        set(value) {
            field = value.absoluteFile
        }

    var version: Any = DEFAULT_VERSION

    val dir: File get() = this.baseDir.resolve(version.toString().encodeURIComponent())

}
