package name.remal.gradle_plugins.artifact

import com.google.common.cache.CacheBuilder
import com.google.common.cache.CacheLoader
import com.google.common.cache.LoadingCache
import org.slf4j.LoggerFactory
import java.io.File
import java.util.concurrent.TimeUnit.MINUTES

internal object ArtifactsCache {

    @JvmStatic private val logger = LoggerFactory.getLogger(ArtifactsCache::class.java)

    private val cache: LoadingCache<File, Artifact> = CacheBuilder.newBuilder()
        .softValues()
        .expireAfterAccess(5, MINUTES)
        .build(object : CacheLoader<File, Artifact>() {
            override fun load(file: File) = Artifact(file)
        });

    operator fun get(file: File): Artifact = cache[file]

    fun invalidate(file: File) {
        logger.debug("Invalidation artifacts cache for {}", file)
        cache.invalidate(file)
    }

}
