package name.remal.gradle_plugins.artifact

import name.remal.gradle_plugins.utils.Constants.CLASS_FILE_NAME_SUFFIX
import name.remal.gradle_plugins.utils.resourcePathToClassName
import java.util.*
import java.util.stream.Collectors

internal abstract class BaseHasEntries : HasEntries {

    override val classEntryNames: Set<String> by lazy(LazyThreadSafetyMode.NONE) {
        val result: Set<String> = entryNames.stream()
            .filter { it.endsWith(CLASS_FILE_NAME_SUFFIX) }
            .collect(Collectors.toCollection(::TreeSet))
        return@lazy result
    }

    override val notClassEntryNames: Set<String> by lazy(LazyThreadSafetyMode.NONE) {
        val result: Set<String> = entryNames.stream()
            .filter { !it.endsWith(CLASS_FILE_NAME_SUFFIX) }
            .collect(Collectors.toCollection(::TreeSet))
        return@lazy result
    }

    override val classNames: Set<String> by lazy(LazyThreadSafetyMode.NONE) {
        val result: Set<String> = entryNames.stream()
            .filter { it.endsWith(CLASS_FILE_NAME_SUFFIX) }
            .map(::resourcePathToClassName)
            .collect(Collectors.toCollection(::TreeSet))
        return@lazy result
    }

    override val manifestMainAttributes: Map<String, String> by lazy(LazyThreadSafetyMode.NONE) {
        mutableMapOf<String, String>().apply {
            readManifest()?.mainAttributes?.forEach { key, value ->
                if (null == key || null == value) return@forEach
                put(key.toString(), value.toString())
            }
        }.toMap()
    }

}
