package name.remal.gradle_plugins.artifact

import name.remal.gradle_plugins.utils.classToResourcePath
import java.io.InputStream
import java.util.jar.JarFile.MANIFEST_NAME
import java.util.jar.Manifest

internal interface HasEntries {

    val entryNames: Set<String>

    val classEntryNames: Set<String>
    val notClassEntryNames: Set<String>

    operator fun contains(entryName: String): Boolean = entryName in entryNames

    @Throws(ArtifactEntryNotFoundException::class, ArtifactFileNotFoundException::class)
    fun openStream(entryName: String): InputStream

    val classNames: Set<String>

    fun containsClass(className: String): Boolean = className in classNames
    fun containsClass(clazz: Class<*>): Boolean = containsClass(clazz.name)

    @Throws(ArtifactEntryNotFoundException::class, ArtifactFileNotFoundException::class)
    fun openStreamForClass(className: String): InputStream = openStream(classToResourcePath(className))

    @Throws(ArtifactEntryNotFoundException::class, ArtifactFileNotFoundException::class)
    fun openStreamForClass(clazz: Class<*>): InputStream = openStreamForClass(clazz.name)

    val manifestMainAttributes: Map<String, String>

    fun readManifest(): Manifest? {
        try {
            openStream(MANIFEST_NAME).use {
                return Manifest(it)
            }
        } catch (e: ArtifactFileNotFoundException) {
            return null
        } catch (e: ArtifactEntryNotFoundException) {
            return null
        }
    }

}
