package name.remal.gradle_plugins.classes_relocation

import name.remal.gradle_plugins.utils.ASM_API
import org.objectweb.asm.AnnotationVisitor
import org.objectweb.asm.ClassVisitor
import org.objectweb.asm.TypePath

internal class DoNotProcessAnnotationAdder(classVisitor: ClassVisitor) : ClassVisitor(ASM_API, classVisitor) {

    companion object {
        const val DO_NOT_PROCESS_DESC = "Lname/remal/classes_processing/DoNotProcess;"
    }

    override fun visit(version: Int, access: Int, name: String?, signature: String?, superName: String?, interfaces: Array<out String>?) {
        super.visit(version, access, name, signature, superName, interfaces)
        super.visitAnnotation(DO_NOT_PROCESS_DESC, false).visitEnd()
    }

    override fun visitAnnotation(desc: String?, visible: Boolean): AnnotationVisitor? {
        if (DO_NOT_PROCESS_DESC == desc) return null
        return super.visitAnnotation(desc, visible)
    }

    override fun visitTypeAnnotation(typeRef: Int, typePath: TypePath?, desc: String?, visible: Boolean): AnnotationVisitor? {
        if (DO_NOT_PROCESS_DESC == desc) return null
        return super.visitTypeAnnotation(typeRef, typePath, desc, visible)
    }

}
