package name.remal.gradle_plugins.classes_relocation

import name.remal.gradle_plugins.utils.ASM_API
import org.objectweb.asm.*

internal class RelocatedClassesTransformer(classVisitor: ClassVisitor) : ClassVisitor(ASM_API, classVisitor) {

    private companion object {
        val ANNOTATION_DESCS_TO_REMOVE = setOf<String>()
    }

    override fun visitAnnotation(desc: String?, visible: Boolean): AnnotationVisitor? {
        if (!visible || desc in ANNOTATION_DESCS_TO_REMOVE) return null
        return super.visitAnnotation(desc, visible)
    }

    override fun visitTypeAnnotation(typeRef: Int, typePath: TypePath?, desc: String?, visible: Boolean): AnnotationVisitor? {
        if (!visible || desc in ANNOTATION_DESCS_TO_REMOVE) return null
        return super.visitTypeAnnotation(typeRef, typePath, desc, visible)
    }

    override fun visitField(access: Int, name: String?, fieldDesc: String?, signature: String?, value: Any?): FieldVisitor? {
        return object : FieldVisitor(api, super.visitField(access, name, fieldDesc, signature, value)) {
            override fun visitAnnotation(desc: String?, visible: Boolean): AnnotationVisitor? {
                if (!visible || desc in ANNOTATION_DESCS_TO_REMOVE) return null
                return super.visitAnnotation(desc, visible)
            }

            override fun visitTypeAnnotation(typeRef: Int, typePath: TypePath?, desc: String?, visible: Boolean): AnnotationVisitor? {
                if (!visible || desc in ANNOTATION_DESCS_TO_REMOVE) return null
                return super.visitTypeAnnotation(typeRef, typePath, desc, visible)
            }
        }
    }

    override fun visitMethod(access: Int, name: String?, methodDesc: String?, signature: String?, exceptions: Array<out String>?): MethodVisitor? {
        return object : MethodVisitor(api, super.visitMethod(access, name, methodDesc, signature, exceptions)) {
            override fun visitAnnotation(desc: String?, visible: Boolean): AnnotationVisitor? {
                if (!visible || desc in ANNOTATION_DESCS_TO_REMOVE) return null
                return super.visitAnnotation(desc, visible)
            }

            override fun visitTypeAnnotation(typeRef: Int, typePath: TypePath?, desc: String?, visible: Boolean): AnnotationVisitor? {
                if (!visible || desc in ANNOTATION_DESCS_TO_REMOVE) return null
                return super.visitTypeAnnotation(typeRef, typePath, desc, visible)
            }

            override fun visitTryCatchAnnotation(typeRef: Int, typePath: TypePath?, desc: String?, visible: Boolean): AnnotationVisitor? {
                if (!visible || desc in ANNOTATION_DESCS_TO_REMOVE) return null
                return super.visitTryCatchAnnotation(typeRef, typePath, desc, visible)
            }

            override fun visitInsnAnnotation(typeRef: Int, typePath: TypePath?, desc: String?, visible: Boolean): AnnotationVisitor? {
                if (!visible || desc in ANNOTATION_DESCS_TO_REMOVE) return null
                return super.visitInsnAnnotation(typeRef, typePath, desc, visible)
            }

            override fun visitParameterAnnotation(parameter: Int, desc: String?, visible: Boolean): AnnotationVisitor? {
                if (!visible || desc in ANNOTATION_DESCS_TO_REMOVE) return null
                return super.visitParameterAnnotation(parameter, desc, visible)
            }

            override fun visitLocalVariableAnnotation(typeRef: Int, typePath: TypePath?, start: Array<out Label>?, end: Array<out Label>?, index: IntArray?, desc: String?, visible: Boolean): AnnotationVisitor? {
                if (!visible || desc in ANNOTATION_DESCS_TO_REMOVE) return null
                return super.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, desc, visible)
            }
        }
    }

}
