package name.remal.gradle_plugins.coverage_metrics

import com.google.common.collect.ImmutableMultimap
import name.remal.gradle_plugins.utils.stringValuesMultimap
import org.objectweb.asm.tree.AnnotationNode

internal data class CoverageMetricsAnnotationInfo(
    val className: String,
    val checkValues: ImmutableMultimap<String, String>
) {

    fun match(annotationNode: AnnotationNode): Boolean {
        if (annotationNode.desc != "L" + className.replace('.', '/') + ";") return false
        annotationNode.stringValuesMultimap.let { stringValuesMultimap ->
            stringValuesMultimap.keySet().forEach { field ->
                val valuesToCheck = checkValues[field] ?: return@forEach
                if (valuesToCheck.any { it !in stringValuesMultimap[field] }) {
                    return false
                }
            }
        }
        return true
    }

}
