package name.remal.gradle_plugins.dsl

import name.remal.gradle_plugins.utils.get
import name.remal.gradle_plugins.utils.getOrCreate
import org.gradle.api.Project
import org.gradle.api.tasks.SourceSet.MAIN_SOURCE_SET_NAME
import org.gradle.api.tasks.bundling.AbstractArchiveTask
import org.gradle.api.tasks.bundling.Jar

val SOURCES_JAR_TASK_NAME = "sourcesJar"
val SOURCES_JAR_CLASSIFIER = "sources"
fun Project.getOrCreateSourcesJarTask(): AbstractArchiveTask {
    val task = tasks.getOrCreate(SOURCES_JAR_TASK_NAME, Jar::class.java) {
        it.classifier = SOURCES_JAR_CLASSIFIER
        it.from(project.java.sourceSets[MAIN_SOURCE_SET_NAME].allSource.makeSrcDirsUnique())
    }
    return task as AbstractArchiveTask
}


val EMPTY_JAVADOC_JAR_TASK_NAME = "emptyJavadocJar"
val JAVADOC_JAR_CLASSIFIER = "javadoc"
fun Project.getOrCreateEmptyJavadocJarTask(): AbstractArchiveTask {
    val task = tasks.getOrCreate(EMPTY_JAVADOC_JAR_TASK_NAME, Jar::class.java) {
        it.classifier = JAVADOC_JAR_CLASSIFIER
    }
    return task as AbstractArchiveTask
}
