package name.remal.gradle_plugins.dsl

import org.gradle.api.file.FileCollection
import java.io.File
import java.net.URLClassLoader

inline fun <T> FileCollection.forClassLoader(additionalFiles: Collection<File> = listOf(), action: (ClassLoader) -> T): T {
    val classLoaderURLs = sequenceOf(this.files.asSequence(), additionalFiles.asSequence())
        .flatten()
        .filter {
            if (it.isDirectory) return@filter true
            if (it.isFile) {
                if (it.name.endsWith(".pom")) return@filter false
                return@filter true
            }
            return@filter false
        }
        .map { it.toURI().toURL() }
        .toList()
    return URLClassLoader(classLoaderURLs.toTypedArray()).use(action)
}
