package name.remal.gradle_plugins.dsl

import name.remal.gradle_plugins.utils.PluginIds
import name.remal.gradle_plugins.utils.addIfNotContains
import name.remal.gradle_plugins.utils.get
import name.remal.gradle_plugins.utils.withPlugin
import org.gradle.api.Project
import org.gradle.api.file.SourceDirectorySet
import org.gradle.api.plugins.JavaPluginConvention
import org.gradle.api.tasks.SourceSet
import org.gradle.api.tasks.testing.Test

// Project:

val Project.java: JavaPluginConvention get() = this[JavaPluginConvention::class.java]

private val javaPackageNameProhibitedChars = Regex("[^.\\w]")
private val javaPackageNameProhibitedCharsAfterDot = Regex("\\.([^A-Za-z_])")
val Project.javaPackageName: String
    get() {
        var result = buildString {
            append(group)
            append('.')
            append(name)
        }
        result = result.replace(':', '.')
        while (result.contains("..")) result = result.replace("..", ".")
        result = result.trim('.')
        result = result.replace(javaPackageNameProhibitedChars, "_")
        result = result.replace(javaPackageNameProhibitedCharsAfterDot, "._$1")
        return result
    }


// Extensions:

fun Project.setupJavaExtensions() {
    this.withPlugin(PluginIds.JAVA_PLUGIN_ID) {
        this.extensions.addIfNotContains("javaPackageName", this.javaPackageName)
    }
}


// SourceSet:

val SourceSet.aptConfigurationName: String get() = this.getTaskName("", "apt")

val SourceSet.generateJavaSourcesTaskName: String get() = this.getTaskName("generate", "JavaSources")


// SourceDirectorySet:

fun SourceDirectorySet.makeSrcDirsUnique() = this.apply {
    setSrcDirs(LinkedHashSet(srcDirs))
}


// Test:

private val testFrameworkField = Test::class.java.getDeclaredField("testFramework").apply { isAccessible = true }
val Test.isTestFrameworkSet: Boolean get() = null != testFrameworkField[this]
