package name.remal.gradle_plugins.dsl

import com.google.common.base.CaseFormat
import org.gradle.api.Task
import org.gradle.api.plugins.JavaBasePlugin.VERIFICATION_GROUP

fun Task.disableCache() {
    outputs.doNotCacheIf("Cache disabled") { true }
    outputs.upToDateWhen { false }
}

private val isTestTestRegex = Regex("\\b(?:test|check)\\b")
val Task.isTestTask: Boolean
    get() {
        if (VERIFICATION_GROUP == this.group) return true
        if (isTestTestRegex.containsMatchIn(this.name.caseFormat(CaseFormat.UPPER_CAMEL, CaseFormat.LOWER_HYPHEN))) return true
        return false
    }
