package name.remal.gradle_plugins.generate_sources.java

import com.google.common.base.CaseFormat
import name.remal.gradle_plugins.dsl.caseFormat
import name.remal.gradle_plugins.dsl.escapeJava
import name.remal.gradle_plugins.utils.id
import org.gradle.api.Project
import java.io.Writer
import java.util.regex.Pattern
import kotlin.text.RegexOption.IGNORE_CASE

class BuildInfoGenerator : JavaClassSourceGenerator() {

    init {
        simpleClassName = "BuildInfo"
    }

    var writeProjectId: Boolean = true

    fun writeProjectId(writeProjectId: Boolean) = apply {
        this.writeProjectId = writeProjectId
    }

    private val properties = LinkedHashMap<String, Any?>()

    fun writeProperty(property: String, propertyValue: Any) = apply {
        properties.put(property, propertyValue)
    }

    fun writeProperty(property: String) = apply {
        properties.put(property, null)
    }

    fun writeProperties(propertiesPattern: String) = writeProperty(propertiesPattern)

    override fun accept(project: Project, writer: Writer) {
        writer.run {
            writePackage()
            writeSuppressWarnings()
            writeBlock("${if (isPublic) "public " else ""}interface $simpleClassName") {

                val values = LinkedHashMap<String, String?>()
                properties.forEach { property, propertyValue ->
                    if (null != propertyValue) {
                        values[property] = propertyValue.toString()

                    } else if (property.contains('*')) {
                        val regex = Regex(property.split('*').joinToString(".*", transform = Pattern::quote), IGNORE_CASE)
                        project.properties.forEach { name, value ->
                            if (name.matches(regex)) {
                                values[name] = value?.toString()
                            }
                        }

                    } else {
                        values[property] = project.property(property)?.toString()
                    }
                }

                val info = LinkedHashMap<String, String?>()
                if (writeProjectId) info["PROJECT_ID"] = project.id
                values.forEach { property, value ->
                    val name = buildString {
                        property
                            .caseFormat(CaseFormat.LOWER_CAMEL, CaseFormat.LOWER_HYPHEN)
                            .caseFormat(CaseFormat.LOWER_HYPHEN, CaseFormat.UPPER_UNDERSCORE)
                            .forEachIndexed { index, char ->
                                if (0 == index) {
                                    append(if (Character.isJavaIdentifierStart(char)) char else '_')
                                } else {
                                    append(if (Character.isJavaIdentifierPart(char)) char else '_')
                                }
                            }
                    }
                    info[name] = value
                }

                info.forEach { name, value ->
                    append("String ").append(name).append(" = ")
                    if (null == value) {
                        append("null")
                    } else {
                        append("new String(\"").append(value.escapeJava()).append("\")")
                    }
                    append(";\n")
                }

            }
        }
    }

}
