package name.remal.gradle_plugins.generate_sources.kotlin

import name.remal.gradle_plugins.generate_sources.BaseSourceGenerator
import java.io.Writer

abstract class KotlinSourceGenerator : BaseSourceGenerator {

    constructor() : super()
    constructor(packageName: String, fileName: String) : super(packageName, fileName)

    override fun Writer.writePackage() {
        if (packageName.isNotEmpty()) {
            append("package ").append(packageName).append("\n")
        }
    }

    override fun Writer.writeImport(canonicalClassName: String) {
        append("import ").append(canonicalClassName).append("\n")
    }

    override fun Writer.writeStaticImport(canonicalClassName: String, member: String) {
        append("import static ").append(canonicalClassName).append('.').append(member).append("\n")
    }

}
