package name.remal.gradle_plugins.packed_dependencies

import name.remal.gradle_plugins.API
import name.remal.gradle_plugins.dsl.createParentDirectories
import name.remal.gradle_plugins.dsl.forceDelete
import org.gradle.api.DefaultTask
import org.gradle.api.artifacts.Configuration
import org.gradle.api.tasks.CacheableTask
import org.gradle.api.tasks.InputFiles
import org.gradle.api.tasks.OutputDirectory
import org.gradle.api.tasks.TaskAction
import java.io.File

@CacheableTask
@API
class GeneratePackedDependenciesResourcesTask : DefaultTask() {

    init {
        description = "Generate packed dependencies resources"
        onlyIf { packedDependenciesConfiguration.allDependencies.isNotEmpty() }
    }

    @get:InputFiles
    lateinit var packedDependenciesConfiguration: Configuration

    @get:OutputDirectory
    val outputDir: File by lazy { project.buildDir.resolve("generated/packed-deps-resources") }

    @TaskAction
    protected fun generateResources() {
        outputDir.forceDelete()

        packedDependenciesConfiguration.createPackedDependencyInfos(project).forEach { info ->
            val targetFile = outputDir.resolve(info.resourceName)
            targetFile.createParentDirectories()
            info.artifactFile.copyTo(targetFile)
        }

        didWork = true
    }

}
