package name.remal.gradle_plugins.packed_dependencies

import name.remal.gradle_plugins.API
import name.remal.gradle_plugins.dsl.createParentDirectories
import name.remal.gradle_plugins.dsl.forceDelete
import name.remal.gradle_plugins.dsl.javaPackageName
import name.remal.gradle_plugins.utils.JavaEnvironmentConfiguration
import org.gradle.api.DefaultTask
import org.gradle.api.artifacts.Configuration
import org.gradle.api.tasks.*
import org.jtwig.JtwigModel
import org.jtwig.JtwigTemplate.classpathTemplate
import java.io.File

@CacheableTask
@API
class GeneratePackedDependenciesSourcesTask : DefaultTask() {

    init {
        description = "Generate packed dependencies Java sources"
        onlyIf { packedDependenciesConfiguration.allDependencies.isNotEmpty() }
    }

    private var packageNameField: String? = null

    @get:Input
    var packageName: String
        set(value) {
            packageNameField = value
        }
        get() = packageNameField ?: project.javaPackageName

    @get:Input
    val classLoaderClassSimpleName: String = "PackedDependenciesClassLoader"

    @get:Input
    var isPublicClass: Boolean = false

    @get:InputFiles
    lateinit var packedDependenciesConfiguration: Configuration

    @get:OutputDirectory
    val outputDir: File by lazy { project.buildDir.resolve("generated/packed-deps-sources") }

    @TaskAction
    protected fun generateSources() {
        outputDir.forceDelete()

        generatePackedDependenciesClassLoader()

        didWork = true
    }

    private fun generatePackedDependenciesClassLoader() {
        outputDir.resolve(packageName.replace('.', '/')).resolve(classLoaderClassSimpleName + ".java").createParentDirectories().outputStream().use { outputStream ->
            val environmentConfiguration = JavaEnvironmentConfiguration()
            val template = classpathTemplate(this::class.java.`package`.name.replace('.', '/') + "/PackedDependenciesClassLoader.twig", environmentConfiguration)

            val model = JtwigModel.newModel()
                .with("packageName", packageName)
                .with("simpleClassName", classLoaderClassSimpleName)
                .with("isPublicClass", isPublicClass)
                .with("resourceNames", packedDependenciesConfiguration.createPackedDependencyInfos(project).map(PackedDependencyInfo::resourceName))

            template.render(model, outputStream)
        }
    }

}
