package name.remal.gradle_plugins.utils

import name.remal.gradle_plugins.API
import org.gradle.api.Task
import java.util.concurrent.atomic.AtomicLong

abstract class TaskAction<in TaskType : Task> : Ordered {

    private companion object {
        val INSTANCES_COUNTER = AtomicLong(0)
    }

    private val instanceNum = INSTANCES_COUNTER.incrementAndGet()

    abstract fun execute(task: TaskType)

    override fun compareTo(other: Ordered): Int {
        return super.compareTo(other).let {
            if (0 == it && other is TaskAction<*>) {
                instanceNum.compareTo(other.instanceNum)
            } else {
                it
            }
        }
    }

}


@API internal class DoFirstTaskActionsExtension<TaskType : Task> : AbstractTaskActionsExtension<TaskType>()
@API internal class DoLastTaskActionsExtension<TaskType : Task> : AbstractTaskActionsExtension<TaskType>()

internal abstract class AbstractTaskActionsExtension<TaskType : Task> {
    val actions = mutableListOf<TaskAction<TaskType>>()
}
