package name.remal.gradle_plugins.utils

import name.remal.gradle_plugins.dsl.default
import org.gradle.api.artifacts.*

internal data class DependencyKey(
    val group: String?,
    val name: String?
) : Comparable<DependencyKey> {

    private val stringRepresentation = "${group.default()}:${name.default()}"

    override fun toString(): String {
        return stringRepresentation
    }

    override fun compareTo(other: DependencyKey): Int {
        return toString().compareTo(other.toString())
    }

}

internal val Dependency.dependencyKey: DependencyKey get() = DependencyKey(this.group, this.name)
internal val ResolvedDependency.dependencyKey: DependencyKey get() = DependencyKey(this.moduleGroup, this.moduleName)
internal val ModuleVersionIdentifier.dependencyKey: DependencyKey get() = DependencyKey(this.group, this.name)
internal val DependencyResolveDetails.dependencyKey: DependencyKey get() = DependencyKey(this.requested.group, this.requested.name)
internal val ModuleVersionSelector.dependencyKey: DependencyKey get() = DependencyKey(this.group, this.name)
