package name.remal.gradle_plugins.utils

import org.gradle.api.tasks.util.PatternFilterable
import org.gradle.testing.jacoco.tasks.JacocoReportBase

internal fun <T : JacocoReportBase> T.filterClassDirectories(filter: (PatternFilterable) -> Unit): T = apply {
    this.classDirectories = this.classDirectories?.apply { asFileTree.matching(filter) }
}

internal fun <T : JacocoReportBase> T.filterAdditionalClassDirs(filter: (PatternFilterable) -> Unit): T = apply {
    this.additionalClassDirs = this.additionalClassDirs?.apply { asFileTree.matching(filter) }
}

internal fun <T : JacocoReportBase> T.filterAllClassDirectories(filter: (PatternFilterable) -> Unit): T = apply {
    filterClassDirectories(filter)
    filterAdditionalClassDirs(filter)
}


