package name.remal.gradle_plugins.utils

import name.remal.gradle_plugins.RemalGradlePlugins.PLUGIN_CLASS_TO_ID
import name.remal.gradle_plugins.RemalGradlePlugins.PLUGIN_ID_TO_CLASS
import org.gradle.api.Project

fun Project.isDisabledBy(disablerPluginId: String): Boolean {
    if (this.pluginManager.hasPlugin(disablerPluginId)) return true

    val invokedFromPluginId = Throwable().stackTrace.asSequence()
        .filterNotNull()
        .map(StackTraceElement::getClassName)
        .filterNotNull()
        .map { className -> PLUGIN_CLASS_TO_ID.entries.firstOrNull { it.key.name == className }?.value }
        .firstOrNull { !it.isNullOrEmpty() }
    this.withPlugin(disablerPluginId) {
        org.slf4j.LoggerFactory.getLogger(PLUGIN_ID_TO_CLASS[disablerPluginId]?.name ?: disablerPluginId).warn(buildString {
            append("There is no sense to apply '").append(disablerPluginId).append("' plugin after ")
            if (null != invokedFromPluginId) {
                append("'").append(invokedFromPluginId).append("' plugin")
            } else {
                append(" plugin that it disables")
            }
        })
    }

    return false
}
