package name.remal.gradle_plugins.vcs

import name.remal.gradle_plugins.dsl.Version
import kotlin.text.RegexOption.IGNORE_CASE

data class VCSVersion(
    val isSpecified: Boolean,
    val baseVersion: Version,
    val branchName: String? = null,
    val commitsAfterBaseVersion: Int = 0,
    val hasUncommittedChanges: Boolean = false
) {

    private companion object {
        val BRANCH_NAME_FORBIDDEN_CHARS_REGEX = Regex("[^a-z0-9_-]", IGNORE_CASE)
    }

    val version: Version
        get() {
            var result = baseVersion

            repeat(commitsAfterBaseVersion) { result = result.incrementPatch() }

            val preReleaseVersion = buildString {
                if (!isSpecified) {
                    if (isNotEmpty()) append('-')
                    append("unspecified")
                }
                if (null != branchName && branchName.isNotEmpty()) {
                    if (isNotEmpty()) append('-')
                    var token: String = branchName
                    if (60 < token.length) {
                        token = token.substring(0, 60)
                    }
                    token = BRANCH_NAME_FORBIDDEN_CHARS_REGEX.replace(token, "-")
                    token = token.trim('-')
                    append(token)
                }
                if (hasUncommittedChanges) {
                    if (isNotEmpty()) append('-')
                    append("uncommitted")
                }
            }
            if (preReleaseVersion.isNotEmpty()) {
                result = result.withSuffix(preReleaseVersion)
            }

            return result
        }

}
