package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.artifact.ArtifactsCacheCleanerPlugin
import name.remal.building.gradle_plugins.utils.ProjectPlugin
import name.remal.building.gradle_plugins.utils.applyPlugin
import name.remal.building.gradle_plugins.utils.configureTasks
import name.remal.building.gradle_plugins.utils.use
import org.eclipse.jgit.api.Git
import org.eclipse.jgit.lib.Constants.DOT_GIT
import org.eclipse.jgit.storage.file.FileRepositoryBuilder
import org.gradle.api.Project
import org.gradle.api.tasks.bundling.AbstractArchiveTask
import org.gradle.api.tasks.wrapper.Wrapper
import java.io.File

open class CommonSettingsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        project.applyPlugin(ArtifactsCacheCleanerPlugin::class.java)

        project.configureTasks(AbstractArchiveTask::class.java) {
            it.isReproducibleFileOrder = true
        }

        project.configureTasks(Wrapper::class.java) { task ->
            task.doLast {
                task.propertiesFile.writeText(
                        task.propertiesFile.readLines().asSequence()
                                .map { it.substringBefore('#').trim() }
                                .filter(String::isNotEmpty)
                                .joinToString("\n")
                )

                var repositoryRootDir = project.rootDir.absoluteFile
                while (true) {
                    if (repositoryRootDir.resolve(DOT_GIT).isDirectory) {
                        FileRepositoryBuilder.create(repositoryRootDir.resolve(DOT_GIT)).use useRepository@ { repository ->
                            Git(repository).use { git ->
                                val propertiesFileRelativePath = task.propertiesFile.absoluteFile.toRelativeString(repositoryRootDir).replace(File.separatorChar, '/')
                                val status = git.status().addPath(propertiesFileRelativePath).call()
                                if (status.isClean) {
                                    try {
                                        val archiveRelativePath = task.jarFile.absoluteFile.toRelativeString(repositoryRootDir).replace(File.separatorChar, '/')
                                        git.checkout().addPath(archiveRelativePath).call()
                                    } catch (ignored: Throwable) {
                                        // do nothing
                                    }
                                }
                            }
                        }
                    }
                    repositoryRootDir = repositoryRootDir.parentFile ?: break
                }
            }
        }
    }

}