package name.remal.building.gradle_plugins

import groovy.transform.CompileStatic
import name.remal.building.gradle_plugins.artifact.ArtifactsCacheCleanerPlugin
import name.remal.building.gradle_plugins.utils.ProjectPlugin
import org.gradle.api.Project
import org.jetbrains.annotations.NotNull

import static name.remal.building.gradle_plugins.utils.PluginIds.ECLIPSE_PLUGIN_ID
import static name.remal.building.gradle_plugins.utils.PluginIds.IDEA_PLUGIN_ID

@CompileStatic
class DefaultPluginsPlugin extends ProjectPlugin {

    @Override
    void apply(@NotNull Project project) {
        project.pluginManager.with {
            if (null == project.parent) {
                apply(IDEA_PLUGIN_ID)
                apply(ECLIPSE_PLUGIN_ID)
                apply(ArtifactsCacheCleanerPlugin.class)
                apply(CheckUpdatesPlugin.class)
            }

            apply(IdeaSettingsPlugin.class)
            apply(EclipseSettingsPlugin.class)

            apply(OSDetectorPlugin.class)
            apply(CommonSettingsPlugin.class)
            apply(DynamicDependenciesPlugin.class)

            apply(JavaSettingsPlugin.class)
            apply(AptPlugin.class)
            apply(KotlinSettingsPlugin.class)
            apply(GroovySettingsPlugin.class)

            apply(FindbugsSettingsPlugin.class)
            apply(QualitySettingsPlugin.class)

            apply(PublishSettingsPlugin.class)
            apply(BintraySettingsPlugin.class)

            apply(ClassesRelocationPlugin.class)
            apply(MergeJavaServicesPlugin.class)
            apply(AgentPlugin.class)
        }
    }

}
