package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.utils.PluginIds.ECLIPSE_PLUGIN_ID
import name.remal.building.gradle_plugins.utils.ProjectPlugin
import name.remal.building.gradle_plugins.utils.get
import name.remal.building.gradle_plugins.utils.withPlugin
import org.gradle.api.Project
import org.gradle.plugins.ide.eclipse.model.EclipseModel

open class EclipseSettingsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        project.withPlugin(ECLIPSE_PLUGIN_ID) {
            setupDependenciesResolution(project)
        }
    }

    private fun setupDependenciesResolution(project: Project) {
        project[EclipseModel::class.java].classpath?.apply {
            isDownloadJavadoc = true
            isDownloadSources = true
        }
    }

}