package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.utils.*
import name.remal.building.gradle_plugins.utils.PluginIds.FINDBUGS_PLUGIN_ID
import name.remal.building.gradle_plugins.utils.PluginIds.QUALITY_PLUGIN_ID
import org.gradle.api.Project
import org.gradle.api.plugins.quality.FindBugs
import org.gradle.api.plugins.quality.FindBugsExtension

open class FindbugsSettingsPlugin : ProjectPlugin() {

    companion object {
        const val FINDBUGS_VERSION_PROPERTY = "findbugs.version"
    }

    override fun apply(project: Project) {
        project.withPlugin(FINDBUGS_PLUGIN_ID) {
            project.afterEvaluateOrdered {
                val findbugs = project[FindBugsExtension::class.java]
                if (null == findbugs.toolVersion) {
                    if (project.hasProperty(FINDBUGS_VERSION_PROPERTY)) {
                        findbugs.toolVersion = project.property(FINDBUGS_VERSION_PROPERTY)?.toString()
                    }
                }
            }

            project.configureTasks(FindBugs::class.java) { task ->
                task.classpath = task.classpath.filter { it.isDirectory || isZipFile(it) }
                task.classes = task.classes.filter { it.name.endsWith(".class") }
            }

            project.applyPluginIfExists(QUALITY_PLUGIN_ID)
        }
    }

}