package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.utils.*
import name.remal.building.gradle_plugins.utils.PluginIds.GROOVY_PLUGIN_ID
import name.remal.building.gradle_plugins.utils.PluginIds.KOTLIN_PLUGIN_ID
import org.gradle.api.Project
import org.gradle.api.tasks.SourceSet

open class GroovySettingsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        project.withPlugins(GROOVY_PLUGIN_ID, KOTLIN_PLUGIN_ID) {
            project.afterEvaluateOrdered {
                project.java.sourceSets.configure { sourceSet ->
                    val compileGroovy = project.tasks.findByName(sourceSet.compileGroovyTaskName) ?: return@configure
                    val copyKotlinClasses = project.tasks.findByName("copy${sourceSet.name.capitalize()}KotlinClasses") ?: return@configure
                    compileGroovy.dependsOn(copyKotlinClasses)
                }
            }
        }
    }

}


val SourceSet.compileGroovyTaskName: String get() = this.getCompileTaskName("Groovy")
