package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.utils.*
import name.remal.building.gradle_plugins.utils.PluginIds.IDEA_PLUGIN_ID
import org.gradle.api.Project
import org.gradle.plugins.ide.idea.model.IdeaModel

open class IdeaExtendedSettingsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        if (!project.isRootProject) return
        project.applyPlugin(IDEA_PLUGIN_ID)
        project[IdeaModel::class.java].setup(
                this::setupEntryPointsManager,
                this::setupNullableNotNullManager
        )
    }

    private fun setupEntryPointsManager(ideaModel: IdeaModel) {
        val componentName = "EntryPointsManager"
        ideaModel.writeComponentIfNotExists(componentName, IdeaConfigType.IPR, "misc.xml", { it.appendElement("project", mapOf("version" to IDEA_CONFIG_PROJECT_VERSION)) })

        ideaModel.processConfigs { document ->
            var wasChanged = false
            val entryPointsManager = document.findIdeaComponentElement(componentName) ?: return@processConfigs null
            if (entryPointsManager.addIdeaListStringValuesIfNotContains(listOf(
                    "org.gradle.api.tasks.TaskAction"
                    , "org.immutables.metainf.Metainf.Service"
                    , "com.google.auto.service.AutoService"
                    , "org.mangosdk.spi.ProviderFor"
                    , "org.junit.Test"
                    , "org.testng.annotations.Test"
                    , "org.springframework.stereotype.Component"
                    , "org.springframework.stereotype.Controller"
                    , "org.springframework.stereotype.Repository"
                    , "org.springframework.stereotype.Service"
                    , "org.springframework.web.bind.annotation.RequestMapping"
                    , "org.springframework.web.bind.annotation.RestController"
            ))) wasChanged = true
            return@processConfigs if (wasChanged) document else null
        }
    }

    private fun setupNullableNotNullManager(ideaModel: IdeaModel) {
        val componentName = "NullableNotNullManager"
        ideaModel.writeComponentIfNotExists(componentName, IdeaConfigType.IPR, "misc.xml", { it.appendElement("project", mapOf("version" to IDEA_CONFIG_PROJECT_VERSION)) })

        ideaModel.processConfigs { document ->
            var wasChanged = false
            val nullableNotNullManager = document.findIdeaComponentElement(componentName) ?: return@processConfigs null

            run {
                val myNullables = nullableNotNullManager.findOrAppendElement("option", mapOf("name" to "myNullables")).findOrAppendElement("value")
                if (myNullables.addIdeaListStringValuesIfNotContains(listOf(
                        "org.jetbrains.annotations.Nullable"
                        , "javax.annotation.Nullable"
                        , "javax.annotation.CheckForNull"
                        , "org.springframework.lang.Nullable"
                        , "edu.umd.cs.findbugs.annotations.Nullable"
                        , "android.support.annotation.Nullable"
                        , "org.eclipse.jdt.annotation.Nullable"
                        , "org.gradle.api.Nullable"
                        , "javax.validation.constraints.Null"
                        , "javax.validation.constraints.Null.List"
                ))) wasChanged = true
            }

            run {
                val myNotNulls = nullableNotNullManager.findOrAppendElement("option", mapOf("name" to "myNotNulls")).findOrAppendElement("value")
                if (myNotNulls.addIdeaListStringValuesIfNotContains(listOf(
                        "org.jetbrains.annotations.NotNull"
                        , "javax.annotation.Nonnull"
                        , "edu.umd.cs.findbugs.annotations.NonNull"
                        , "android.support.annotation.NonNull"
                        , "org.eclipse.jdt.annotation.NonNull"
                        , "lombok.NonNull"
                        , "javax.validation.constraints.NotNull"
                        , "javax.validation.constraints.NotNull.List"
                        , "org.hibernate.validator.constraints.NotBlank"
                        , "org.hibernate.validator.constraints.NotBlank.List"
                        , "org.hibernate.validator.constraints.NotEmpty"
                        , "org.hibernate.validator.constraints.NotEmpty.List"
                ))) wasChanged = true
            }

            return@processConfigs if (wasChanged) document else null
        }
    }

}
