package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.utils.ProjectPlugin
import org.gradle.api.Project
import org.jetbrains.annotations.NotNull

import static name.remal.building.gradle_plugins.KotlinSettingsPluginKt.getCompileKotlin2JSTaskName
import static name.remal.building.gradle_plugins.KotlinSettingsPluginKt.getCompileKotlinTaskName
import static name.remal.building.gradle_plugins.utils.GradleUtilsKt.configure
import static name.remal.building.gradle_plugins.utils.JavaProjectKt.getJava
import static name.remal.building.gradle_plugins.utils.PluginIds.*

class KotlinSettingsPlugin extends ProjectPlugin {

    @Override
    void apply(@NotNull Project project) {
        project.pluginManager.withPlugin(KOTLIN_PLUGIN_ID) { setupKotlinJvmCompile(project) }
        project.pluginManager.withPlugin(KOTLIN2JS_PLUGIN_ID) { setupKotlinJsCompile(project) }
        project.pluginManager.withPlugin(KOTLIN_KAPT_PLUGIN_ID) { setupKapt(project) }
    }

    private void setupKotlinJvmCompile(@NotNull Project project) {
        getJava(project).sourceSets.all { sourceSet ->
            configure(project.tasks, getCompileKotlinTaskName(sourceSet)) { task ->
                def options = task.kotlinOptions
                options.jvmTarget = "1.8"
                options.javaParameters = true
            }
        }
    }

    private void setupKotlinJsCompile(@NotNull Project project) {
        getJava(project).sourceSets.all { sourceSet ->
            configure(project.tasks, getCompileKotlin2JSTaskName(sourceSet)) { task ->
                def options = task.kotlinOptions
                options.metaInfo = true
                options.sourceMap = true
                options.moduleKind = "umd"
                options.noStdlib = false
            }
        }
    }

    private void setupKapt(@NotNull Project project) {
        project.kapt.correctErrorTypes = true
    }

}