package name.remal.building.gradle_plugins

import mu.KLogging
import name.remal.building.gradle_plugins.packed_dependencies.GeneratePackedDependenciesResourcesTask
import name.remal.building.gradle_plugins.packed_dependencies.GeneratePackedDependenciesSourcesTask
import name.remal.building.gradle_plugins.utils.*
import name.remal.building.gradle_plugins.utils.PluginIds.JAVA_PLUGIN_ID
import org.gradle.api.Project
import org.gradle.api.tasks.AbstractCopyTask
import org.gradle.api.tasks.SourceSet.MAIN_SOURCE_SET_NAME

open class PackedDependenciesPlugin : ProjectPlugin() {

    companion object : KLogging() {
        const val PACKED_DEPENDENCIES_CONFIGURATION_NAME = "packed"
        const val GENERATE_PACKED_DEPENDENCIES_SOURCES_TASK_NAME = "generatePackedDependenciesSources"
        const val GENERATE_PACKED_DEPENDENCIES_RESOURCES_TASK_NAME = "generatePackedDependenciesResources"
    }

    override fun apply(project: Project) {
        project.withPlugin(JAVA_PLUGIN_ID) {
            val mainSourceSet = project.java.sourceSets[MAIN_SOURCE_SET_NAME]

            val packedDepsConf = project.configurations.create(PACKED_DEPENDENCIES_CONFIGURATION_NAME) {
                it.description = "Dependencies that will be added as resources"
            }
            project.configurations[mainSourceSet.compileOnlyConfigurationName].extendsFrom(packedDepsConf)

            project.afterEvaluateOrdered {
                if (packedDepsConf.allDependencies.isEmpty()) return@afterEvaluateOrdered

                val generatePackedDepsSourcesTask = project.tasks.create(GENERATE_PACKED_DEPENDENCIES_SOURCES_TASK_NAME, GeneratePackedDependenciesSourcesTask::class.java) { task ->
                    task.packedDependenciesConfiguration = packedDepsConf
                }
                mainSourceSet.java.srcDir(generatePackedDepsSourcesTask.outputDir)
                arrayOf("compileKotlin", mainSourceSet.compileJavaTaskName).forEach { taskName ->
                    project.tasks.configure(taskName) { task ->
                        task.dependsOn(generatePackedDepsSourcesTask)
                    }
                }

                val generatePackedDepsResourcesTask = project.tasks.create(GENERATE_PACKED_DEPENDENCIES_RESOURCES_TASK_NAME, GeneratePackedDependenciesResourcesTask::class.java) { task ->
                    task.packedDependenciesConfiguration = packedDepsConf
                }
                mainSourceSet.resources.srcDir(generatePackedDepsResourcesTask.outputDir)
                project.tasks[AbstractCopyTask::class.java].configure(mainSourceSet.processResourcesTaskName) { task ->
                    task.from(generatePackedDepsResourcesTask.outputDir)
                    task.dependsOn(generatePackedDepsResourcesTask)
                }
            }
        }
    }

}