package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.utils.ProjectPlugin
import org.gradle.api.Project
import org.jetbrains.annotations.NotNull

import static name.remal.building.gradle_plugins.utils.PluginIds.JAVA_PLUGIN_ID
import static name.remal.building.gradle_plugins.utils.PluginIds.QUALITY_PLUGIN_ID

class QualitySettingsPlugin extends ProjectPlugin {

    @Override
    void apply(@NotNull Project project) {
        project.pluginManager.withPlugin(JAVA_PLUGIN_ID) {
            project.pluginManager.withPlugin(QUALITY_PLUGIN_ID) {
                project.plugins.apply(FindbugsSettingsPlugin.class)

                project.quality.with {
                    autoRegistration = false
                    configDir = "${project.rootDir}/gradle/config/"
                    excludeSources = project.fileTree(project.buildDir)
                    sourceSets = project.sourceSets

                    strict = false
                }
            }
        }
    }

}
