package name.remal.building.gradle_plugins

import mu.KLogging
import name.remal.building.gradle_plugins.utils.ProjectPlugin
import name.remal.building.gradle_plugins.vcs_auto_version.VCSAutoVersionExtension
import name.remal.building.gradle_plugins.vcs_auto_version.VCSAutoVersionSubplugin
import org.gradle.api.Project
import java.util.*

open class VCSAutoVersionPlugin : ProjectPlugin() {

    companion object : KLogging() {
        const val VCS_AUTO_VERSION_EXTENSION_NAME = "vcsAutoVersion"
    }

    override fun apply(project: Project) {
        if (!project.version?.toString().isNullOrEmpty()) {
            logger.warn("Project version will be redefined by ${VCSAutoVersionPlugin::class.java.simpleName}")
        }

        val subplugins = ServiceLoader.load(VCSAutoVersionSubplugin::class.java).toList().sorted()
        if (subplugins.isEmpty()) {
            logger.error("Instances of ${VCSAutoVersionSubplugin::class.java} are not found")
        }

        val vcsAutoVersion = project.extensions.create(VCS_AUTO_VERSION_EXTENSION_NAME, VCSAutoVersionExtension::class.java)

        var repositoryRootDir = project.rootDir.absoluteFile
        while (true) {
            subplugins.forEach { subplugin ->
                if (subplugin.isDirMatches(repositoryRootDir)) {
                    val vcsVersion = subplugin.calculateVersion(repositoryRootDir, vcsAutoVersion)
                    vcsVersion.version.let { version ->
                        project.version = buildString {
                            append(version.toString())
                            if (!version.preReleaseVersion.isNullOrEmpty()) append("-SNAPSHOT")
                        }
                    }
                    return
                }
            }

            repositoryRootDir = repositoryRootDir.parentFile ?: return
        }
    }

}
