package name.remal.building.gradle_plugins.artifact

import name.remal.building.gradle_plugins.utils.ProjectPlugin
import name.remal.building.gradle_plugins.utils.afterEvaluateOrdered
import name.remal.building.gradle_plugins.utils.applyPlugin
import name.remal.building.gradle_plugins.utils.doLastOrdered
import org.gradle.api.Project
import org.gradle.api.file.FileTree
import org.gradle.api.tasks.Copy
import org.gradle.api.tasks.bundling.AbstractArchiveTask
import org.gradle.api.tasks.compile.AbstractCompile

open class ArtifactsCacheCleanerPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        project.gradle.beforeProject { it.applyPlugin(ArtifactsCacheCleanerPlugin::class.java) }

        project.afterEvaluateOrdered {
            project.tasks.all { task ->
                task.doLastOrdered {
                    if (task is AbstractCompile) {
                        ArtifactsCache.invalidate(task.destinationDir)
                    } else if (task is AbstractArchiveTask) {
                        ArtifactsCache.invalidate(task.archivePath)
                    } else if (task is Copy) {
                        ArtifactsCache.invalidate(task.destinationDir)
                    } else {
                        task.outputs.files.let { outputFiles ->
                            if (outputFiles !is FileTree) {
                                outputFiles.files.forEach(ArtifactsCache::invalidate)
                            }
                        }
                    }
                }
            }
        }
    }

}