package name.remal.building.gradle_plugins.artifact

import java.io.File
import java.io.InputStream
import java.util.*
import kotlin.collections.LinkedHashSet

data class CachedArtifactsCollection(private val artifacts: Set<Artifact>) : BaseHasEntries() {

    constructor(files: Iterable<File>) : this(LinkedHashSet<Artifact>().apply { files.mapTo(this, ArtifactsCache::get) })

    val entryMapping: Map<String, Artifact> by lazy(LazyThreadSafetyMode.NONE) {
        val result = TreeMap<String, Artifact>()
        artifacts.forEach { artifact ->
            artifact.entryNames.forEach { result[it] = artifact }
        }
        return@lazy result
    }

    override val entryNames: Set<String> by lazy(LazyThreadSafetyMode.NONE) { entryMapping.keys }

    override fun openStream(entryName: String): InputStream {
        val artifact = entryMapping[entryName] ?: throw ArtifactEntryNotFoundException("Artifact entry not found: $entryName")
        return artifact.openStream(entryName)
    }

}