package name.remal.building.gradle_plugins.dynamic_dependencies

import groovy.lang.Closure
import org.gradle.api.artifacts.Dependency
import org.gradle.api.artifacts.dsl.DependencyHandler

interface DynamicDependenciesDependencyHandler {
    fun create(dependencyNotation: Any): Dependency
    fun create(dependencyNotation: Any, configureClosure: Closure<*>): Dependency
    fun module(notation: Any): Dependency
    fun module(notation: Any, configureClosure: Closure<*>): Dependency
    fun project(notation: Map<String, *>): Dependency
    fun gradleApi(): Dependency
    fun gradleTestKit(): Dependency
    fun localGroovy(): Dependency
}

class DynamicDependenciesDependencyHandlerImpl(private val dependencyHandler: DependencyHandler) : DynamicDependenciesDependencyHandler {

    override fun create(dependencyNotation: Any): Dependency {
        return dependencyHandler.create(dependencyNotation)
    }

    override fun create(dependencyNotation: Any, configureClosure: Closure<*>): Dependency {
        return dependencyHandler.create(dependencyNotation, configureClosure)
    }

    override fun module(notation: Any): Dependency {
        return dependencyHandler.module(notation)
    }

    override fun module(notation: Any, configureClosure: Closure<*>): Dependency {
        return dependencyHandler.module(notation, configureClosure)
    }

    override fun project(notation: Map<String, *>): Dependency {
        return dependencyHandler.project(notation)
    }

    override fun gradleApi(): Dependency {
        return dependencyHandler.gradleApi()
    }

    override fun gradleTestKit(): Dependency {
        return dependencyHandler.gradleTestKit()
    }

    override fun localGroovy(): Dependency {
        return dependencyHandler.localGroovy()
    }

}