package name.remal.building.gradle_plugins.utils

import org.gradle.api.Task

interface TaskAction<in TaskType : Task> : Ordered {
    fun execute(task: TaskType)
}


open class DoFirstTaskActionsExtension<TaskType : Task> : AbstractTaskActionsExtension<TaskType>()
open class DoLastTaskActionsExtension<TaskType : Task> : AbstractTaskActionsExtension<TaskType>()

abstract class AbstractTaskActionsExtension<TaskType : Task> {
    val actions = mutableListOf<TaskAction<TaskType>>()
}
