package name.remal.building.gradle_plugins.utils

import org.gradle.api.artifacts.*

data class DependencyKey(
        val group: String?,
        val name: String?
) : Comparable<DependencyKey> {

    private val stringRepresentation = "${group.default()}:${name.default()}"

    override fun toString(): String {
        return stringRepresentation
    }

    override fun compareTo(other: DependencyKey): Int {
        return toString().compareTo(other.toString())
    }

}

val Dependency.dependencyKey: DependencyKey get() = DependencyKey(this.group, this.name)
val ResolvedDependency.dependencyKey: DependencyKey get() = DependencyKey(this.moduleGroup, this.moduleName)
val ModuleVersionIdentifier.dependencyKey: DependencyKey get() = DependencyKey(this.group, this.name)
val DependencyResolveDetails.dependencyKey: DependencyKey get() = DependencyKey(this.requested?.group, this.requested?.name)
val ModuleVersionSelector.dependencyKey: DependencyKey get() = DependencyKey(this.group, this.name)
