package name.remal.building.gradle_plugins.utils

import org.gradle.api.tasks.util.PatternFilterable
import org.gradle.testing.jacoco.tasks.JacocoReportBase

fun <T : JacocoReportBase> T.filterClassDirectories(filter: (PatternFilterable) -> Unit): T = apply {
    this.classDirectories = this.classDirectories?.asFileTree?.matching(filter)
}

fun <T : JacocoReportBase> T.filterAdditionalClassDirs(filter: (PatternFilterable) -> Unit): T = apply {
    this.additionalClassDirs = this.additionalClassDirs?.asFileTree?.matching(filter)
}

fun <T : JacocoReportBase> T.filterAllClassDirectories(filter: (PatternFilterable) -> Unit): T = apply {
    filterClassDirectories(filter)
    filterAdditionalClassDirs(filter)
}


