package name.remal.building.gradle_plugins.utils

import org.gradle.api.Project
import org.gradle.api.Task
import org.gradle.api.plugins.JavaPluginConvention
import org.gradle.api.tasks.SourceSet
import org.gradle.api.tasks.testing.Test
import java.lang.Integer.max

// Project:

val Project.java: JavaPluginConvention get() = this[JavaPluginConvention::class.java]

val Project.javaPackageName: String get() = buildString {
    group?.let { append(it.toString()).append('.') }
    append(name)
}.replace(':', '.').replace("..", ".").replace("..", ".").trim('.').replace(Regex("[^.\\w]"), "_").replace(Regex("\\.([^A-Za-z_])"), "._$1")

fun Project.computeClassesTaskHierarchy(sourceSet: SourceSet): List<Task> {
    val allExecutingProjectTasks = gradle.taskGraph.allTasks.filter { it.project == this }

    val classesTaskPositions = this.java.sourceSets.asSequence()
            .map(SourceSet::getClassesTaskName)
            .filterNotNull()
            .map { classesTaskName ->
                val classIndex = allExecutingProjectTasks.indexOfFirst { it.name == classesTaskName }
                if (0 <= classIndex) return@map classesTaskName to classIndex
                return@map null
            }
            .filterNotNull()
            .toMap()

    val classTaskPosition = classesTaskPositions[sourceSet.classesTaskName] ?: return listOf()
    val toIndex = classTaskPosition + 1
    var fromIndex = 0
    classesTaskPositions.forEach { _, pos ->
        if (pos < classTaskPosition) fromIndex = max(fromIndex, pos + 1)
    }
    return allExecutingProjectTasks.subList(fromIndex, toIndex)
}


// Test:

private val testFrameworkField = Test::class.java.getDeclaredField("testFramework").apply { isAccessible = true }
val Test.isTestFrameworkSet: Boolean get() = null != testFrameworkField[this]
