package name.remal.building.gradle_plugins.utils

import com.google.common.collect.ImmutableMap
import org.jtwig.environment.EnvironmentConfiguration
import org.jtwig.environment.initializer.EnvironmentInitializer
import org.jtwig.escape.EscapeEngine
import org.jtwig.escape.config.DefaultEscapeEngineConfiguration
import org.jtwig.escape.config.EscapeEngineConfiguration
import org.jtwig.extension.Extension
import org.jtwig.functions.config.DefaultJtwigFunctionList
import org.jtwig.parser.config.DefaultJtwigParserConfiguration
import org.jtwig.property.configuration.DefaultPropertyResolverConfiguration
import org.jtwig.render.config.DefaultRenderConfiguration
import org.jtwig.render.expression.calculator.enumerated.config.DefaultEnumerationListStrategyList
import org.jtwig.resource.config.DefaultResourceConfiguration
import org.jtwig.value.config.DefaultValueConfiguration

class JavaEnvironmentConfiguration : EnvironmentConfiguration(
        DefaultResourceConfiguration(),
        DefaultEnumerationListStrategyList(),
        DefaultJtwigParserConfiguration(),
        DefaultValueConfiguration(),
        DefaultRenderConfiguration(),
        JavaEscapeEngineConfiguration(),
        DefaultPropertyResolverConfiguration(),
        DefaultJtwigFunctionList(),
        emptyMap<String, Any>(),
        emptyList<Extension>(),
        emptyList<EnvironmentInitializer>()
)

class JavaEscapeEngineConfiguration : EscapeEngineConfiguration(
        "none",
        "java",
        ImmutableMap.builder<String, EscapeEngine>()
                .putAll(DefaultEscapeEngineConfiguration().escapeEngineMap)
                .put("java", JavaEscapeEngine)
                .build()
)

object JavaEscapeEngine : EscapeEngine {
    @Suppress("DEPRECATION")
    override fun escape(input: String?): String? = org.apache.commons.lang3.StringEscapeUtils.escapeJava(input)
}
