package name.remal.building.gradle_plugins.utils

import java.net.HttpURLConnection
import java.net.URL
import java.nio.charset.Charset

fun URL.getHttpBody(): String {
    if ("http" != protocol && "https" != protocol) throw IllegalStateException("Unsupported protocol: $protocol")
    val connection = openConnection()
    connection as HttpURLConnection
    connection.connectTimeout = DEFAULT_IO_TIMEOUT.toMillis().toInt()
    connection.readTimeout = DEFAULT_IO_TIMEOUT.toMillis().toInt()
    connection.useCaches = false
    connection.connect()
    try {
        connection.responseCode.let {
            if (200 != it) throw IllegalStateException("Error getting HTTP body of $this: $it status")
        }

        val charset = run {
            val charset = connection.contentType?.toLowerCase()?.substringAfter("charset=", "")?.substringBefore(';')?.trim()
            if (null != charset) {
                try {
                    return@run Charset.forName(charset.toUpperCase())
                } catch (e: IllegalArgumentException) {
                    // do nothing
                }
            }
            return@run Charsets.UTF_8
        }
        return connection.inputStream.reader(charset).use { it.readText() }

    } finally {
        connection.disconnect()
    }
}
