package name.remal.building.gradle_plugins.vcs_auto_version

import com.github.zafarkhaja.semver.Version
import name.remal.building.gradle_plugins.utils.use
import org.eclipse.jgit.api.Git
import org.eclipse.jgit.lib.Constants.DOT_GIT
import org.eclipse.jgit.lib.Ref
import org.eclipse.jgit.storage.file.FileRepositoryBuilder
import java.io.File

class GitAutoVersionSubplugin : VCSAutoVersionSubplugin {

    override fun isDirMatches(repositoryRootDir: File) = repositoryRootDir.resolve(DOT_GIT).isDirectory

    override fun calculateVersion(repositoryRootDir: File, vcsAutoVersion: VCSAutoVersionExtension): VCSVersion {
        FileRepositoryBuilder.create(repositoryRootDir.resolve(DOT_GIT)).use useRepository@ { repository ->
            Git(repository).use { git ->
                val versionTagPrefixes = vcsAutoVersion.versionTagPrefixes.toSet().sortedDescending()
                val tags: Map<Version, Ref> = git.tagList().call().asSequence()
                        .mapNotNull { tagRef ->
                            val name = tagRef.name.substring("refs/tags/".length)
                            versionTagPrefixes
                                    .firstOrNull { prefix -> name.startsWith(prefix) }
                                    ?.let { prefix -> name.substring(prefix.length).trim() }
                                    ?.let {
                                        try {
                                            Version.valueOf(it)!!
                                        } catch (ignored: Exception) {
                                            null
                                        }
                                    }
                                    ?.let { it to tagRef }
                        }
                        .toMap()


                var commitsAfterBaseVersion = 0
                val baseVersion: Version = run {
                    git.log().call().forEach { revCommit ->
                        tags.entries
                                .firstOrNull { (_, tagRef) -> tagRef.peeledObjectId == revCommit.id || tagRef.objectId == revCommit.id }
                                ?.let { (tagVersion, _) -> return@run tagVersion }
                        ++commitsAfterBaseVersion
                    }
                    return@run Version.forIntegers(0, 0, 0)
                }

                return VCSVersion(
                        baseVersion,
                        repository.branch.let { if (vcsAutoVersion.mainBranchName != it) it else null },
                        commitsAfterBaseVersion,
                        git.status().call().hasUncommittedChanges()
                )
            }
        }
    }

}
