package name.remal.building.gradle_plugins.vcs_auto_version

import com.github.zafarkhaja.semver.Version

data class VCSVersion(
        val baseVersion: Version,
        val branchName: String? = null,
        val commitsAfterBaseVersion: Int = 0,
        val hasUncommittedChanges: Boolean = false
) {

    private companion object {
        val BRANCH_NAME_FORBIDDEN_CHARS_REGEX = Regex("[^a-zA-Z0-9.-]")
    }

    val version: Version get() {
        val preReleaseVersion = buildString {
            if (null != branchName && branchName.isNotEmpty()) {
                if (isNotEmpty()) append('-')
                append(BRANCH_NAME_FORBIDDEN_CHARS_REGEX.replace(branchName, "-"))
            }
            if (1 <= commitsAfterBaseVersion) {
                if (isNotEmpty()) append('-')
                append("commit-").append("%04d".format(commitsAfterBaseVersion))
            }
            if (hasUncommittedChanges) {
                if (isNotEmpty()) append('-')
                append("uncommitted")
            }
        }
        if (preReleaseVersion.isEmpty()) {
            return baseVersion
        } else {
            return baseVersion.setPreReleaseVersion(preReleaseVersion)
        }
    }

}