package name.remal.gradle_plugins.plugins.assertj.internal.impl

import com.google.common.reflect.TypeToken
import name.remal.*
import name.remal.gradle_plugins.dsl.extensions.forClassLoader
import name.remal.gradle_plugins.plugins.assertj.internal.AssertionGeneratorInvoker
import name.remal.reflection.ExtendedURLClassLoader.LoadingOrder.THIS_ONLY
import org.assertj.assertions.generator.BaseAssertionGenerator
import org.assertj.assertions.generator.description.converter.ClassToClassDescriptionConverter
import org.gradle.api.logging.Logger
import java.io.File

internal class AssertionGeneratorInvokerImpl : AssertionGeneratorInvoker {
    override fun invoke(classesDirs: Iterable<File>, classNames: List<String>, outputDir: File, classpath: Iterable<File>, logger: Logger) {

        val contextClassLoader = Thread.currentThread().contextClassLoader
        (classesDirs + classpath).forClassLoader(THIS_ONLY) { classesClassLoader ->
            forThreadContextClassLoader(contextClassLoader) {

                val typeTokens: List<TypeToken<*>> = classNames.stream()
                    .map { className ->
                        classesClassLoader.tryLoadClass(className, false).also {
                            if (it == null) logger.warn("Class can't be loaded: {}", className)
                        }
                    }
                    .filterNotNull()
                    .filter { it.isPublic && !it.isAnonymousClass && !it.isLocalClass }
                    .map { TypeToken.of(it) }
                    .toList()
                    .apply { if (isEmpty()) return@forClassLoader }

                val generator = BaseAssertionGenerator()
                generator.setDirectoryWhereAssertionFilesAreGenerated(outputDir)

                val classDescriptionConverter = ClassToClassDescriptionConverter()
                typeTokens.forEach { typeToken ->
                    logger.info("Generating assertions for class : {}", typeToken)
                    val classDesc = classDescriptionConverter.convertToClassDescription(typeToken)
                    val generatedFiles = generator.generateHierarchicalCustomAssertionFor(classDesc, mutableSetOf())
                    logger.info("Generated {} hierarchical assertions files: {}", generatedFiles.toList())
                }

            }
        }

    }
}
