package name.remal.gradle_plugins.plugins.check_updates

import name.remal.gradle_plugins.dsl.ApplyPluginClasses
import name.remal.gradle_plugins.dsl.BaseReflectiveProjectPlugin
import name.remal.gradle_plugins.dsl.Plugin
import name.remal.gradle_plugins.dsl.PluginAction
import org.gradle.api.plugins.HelpTasksPlugin.HELP_GROUP
import org.gradle.api.tasks.TaskContainer

const val CHECK_UPDATES_TASK_NAME = "checkUpdates"

@Plugin(
    id = "name.remal.check-updates",
    description = "Plugin that provides tasks for discovering dependency and Gradle updates",
    tags = ["versions", "dependency-updates", "gradle-updates"]
)
@ApplyPluginClasses(
    CheckDependencyUpdatesPlugin::class,
    CheckGradleUpdatesPlugin::class
)
class CheckUpdatesPlugin : BaseReflectiveProjectPlugin() {

    @PluginAction
    fun TaskContainer.`Create checkUpdates actions`() {
        create(CHECK_UPDATES_TASK_NAME) { task ->
            val dependentTaskNames = listOf(
                CHECK_DEPENDENCY_UPDATES_TASK_NAME,
                CHECK_GRADLE_UPDATES_TASK_NAME
            )
            task.dependsOn(dependentTaskNames)

            task.group = HELP_GROUP
            task.description = "Executes " + dependentTaskNames.joinToString(", ")
        }
    }

}
