package name.remal.gradle_plugins.plugins.ci

import name.remal.gradle_plugins.dsl.BaseReflectiveProjectPlugin
import name.remal.gradle_plugins.dsl.HighestPriorityPluginAction
import name.remal.gradle_plugins.dsl.extensions.applyPlugin
import name.remal.gradle_plugins.dsl.extensions.unwrapGradleGenerated
import name.remal.gradle_plugins.dsl.utils.findPluginId
import name.remal.uncheckedCast
import org.gradle.api.Project

abstract class BaseCIPlugin : BaseReflectiveProjectPlugin() {

    @HighestPriorityPluginAction("Apply 'name.remal.common-ci' plugin")
    private fun Project.initializationAction() {
        val pluginClass = this@BaseCIPlugin.javaClass.unwrapGradleGenerated()
        logger.lifecycle(
            "{} plugin is enabled",
            findPluginId(pluginClass.uncheckedCast()) ?: pluginClass.name
        )

        applyPlugin(CommonCIPlugin::class.java)
    }

}
