package name.remal.gradle_plugins.plugins.ci

import name.remal.gradle_plugins.dsl.Extension
import name.remal.gradle_plugins.dsl.utils.getGradleLogger

@Extension
class CIExtension {

    companion object {
        @JvmStatic
        private val logger = getGradleLogger(CIExtension::class.java)
    }


    var pipelineId: String? = null
        set(value) {
            if (value != null && field != value) {
                logger.lifecycle("CI: {}: {}", CIExtension::pipelineId.name, value)
            }
            field = value
        }

    var buildId: String? = null
        set(value) {
            if (value != null && field != value) {
                logger.lifecycle("CI: {}: {}", CIExtension::buildId.name, value)
            }
            field = value
        }

    var stageName: String? = null
        set(value) {
            if (value != null && field != value) {
                logger.lifecycle("CI: {}: {}", CIExtension::stageName.name, value)
            }
            field = value
        }

    var jobName: String? = null
        set(value) {
            if (value != null && field != value) {
                logger.lifecycle("CI: {}: {}", CIExtension::jobName.name, value)
            }
            field = value
        }

}
